#lang scheme/base
(require scheme/class fluxus-016/fluxus "message.ss" "list-utils.ss")
(provide (all-defined-out))

; the fluxus code to make things look the way they do

(define debug-messages #f) ; prints out all the messages sent to the renderer
(define audio-on #f)

(define (ornament-colour) (vector 0.5 1 0.4))
(define (pickup-colour) (vector 1 1 1))
(define (earth-colour) (vector 0.2 0.1 0))
(define (stones-colour) (vmul (earth-colour) (+ 0.5 (* (rndf) 0.5))))

(define wire-mode #f)
(define fog-col (earth-colour))
(define fog-strength 0.001)
(define max-ornaments 2) ; per twig
(define default-grow-speed 0.5)

(when audio-on (oa-start)) ;; start openAL audio

(define stones-list '(("meshes/stone3.obj" #(88.65716552734375 -30.131141662597656 -14.273045539855957) 6.2288119 #(93.5999984741211 46.2599983215332 127.6199951171875)) ("meshes/stone1.obj" #(-16.537208557128906 -0.23769862949848175 -84.14227294921875) 7.465884399999999 #(254.41200256347656 102.16799926757812 289.9079895019531)) ("meshes/stone2.obj" #(-6.3884758949279785 -27.86908721923828 -2.308316230773926) 2.197811099999999 #(179.60400390625 243.14401245117188 111.95999908447266)) ("meshes/stone3.obj" #(-105.02485656738281 -2.2274255752563477 -47.926639556884766) 9.9099399 #(201.1320037841797 7.271999835968018 332.927978515625)) ("meshes/stone1.obj" #(83.57180786132812 -0.7033876180648804 -138.9539794921875) 9.3854559 #(57.13199996948242 145.76400756835938 321.6239929199219)) ("meshes/stone2.obj" #(97.58766174316406 -103.76101684570312 -19.672000885009766) 5.7515676 #(125.56800079345703 284.5799865722656 294.1920166015625)) ("meshes/stone2.obj" #(-39.06246566772461 -41.8046760559082 28.33575439453125) 2.9002523999999994 #(209.23199462890625 106.84799194335938 225.61199951171875)) ("meshes/stone3.obj" #(32.91088104248047 -37.054866790771484 -27.48905372619629) 2.422297499999999 #(90.10799407958984 59.58000183105469 9.539999961853027)) ("meshes/stone2.obj" #(156.15773010253906 -170.59864807128906 197.6505126953125) 9.7251036 #(122.43599700927734 209.30398559570312 286.99200439453125)) ("meshes/stone2.obj" #(-34.811832427978516 -1.5052777528762817 11.31139087677002) 5.3596656 #(115.8479995727539 19.512001037597656 348.5879821777344)) ("meshes/stone2.obj" #(11.945683479309082 -40.707054138183594 -14.522078514099121) 2.5350400000000004 #(94.9679946899414 73.04400634765625 216.9359893798828)) ("meshes/stone2.obj" #(44.43638610839844 -34.35142135620117 -71.41991424560547) 6.5952775 #(243.64801025390625 273.2760009765625 254.12400817871094)) ("meshes/stone1.obj" #(176.47447204589844 -1.395991325378418 70.94943237304688) 9.8967744 #(220.60800170898438 328.8600158691406 304.6319885253906)) ("meshes/stone1.obj" #(367.205810546875 -27.378562927246094 -125.2353286743164) 9.819635100000001 #(116.35199737548828 341.6400146484375 285.80401611328125)) ("meshes/stone2.obj" #(-166.19747924804688 -2.2105579376220703 -227.12371826171875) 9.6150556 #(200.41200256347656 103.39199829101562 198.9720001220703)) ("meshes/stone2.obj" #(-83.77057647705078 -94.48277282714844 -253.73516845703125) 9.8322975 #(295.20001220703125 12.276000022888184 180.79200744628906)) ("meshes/stone2.obj" #(-86.88694763183594 -2.792271852493286 29.244083404541016) 5.6545536 #(76.4280014038086 318.7080078125 321.8760070800781)) ("meshes/stone2.obj" #(104.50371551513672 -103.5042724609375 -275.2379150390625) 9.8103871 #(290.447998046875 31.31999969482422 191.26800537109375)) ("meshes/stone3.obj" #(-91.02245330810547 -177.52435302734375 160.25555419921875) 9.38991 #(46.76399612426758 139.28399658203125 222.156005859375)) ("meshes/stone3.obj" #(109.23974609375 -1.496395230293274 -27.918882369995117) 7.155911100000001 #(46.90800094604492 209.9879913330078 230.25599670410156)) ("meshes/stone3.obj" #(-33.301361083984375 -1.345281958580017 67.05613708496094) 5.803551599999999 #(173.8800048828125 327.4200134277344 289.656005859375)) ("meshes/stone1.obj" #(34.29657745361328 -131.6463623046875 24.48255157470703) 5.754174399999998 #(280.9440002441406 232.7760009765625 315.5400085449219)) ("meshes/stone1.obj" #(3.962696075439453 -279.7259521484375 -7.7145304679870605) 9.9925471 #(51.98400115966797 283.28399658203125 74.16000366210938)) ("meshes/stone2.obj" #(-151.34654235839844 -12.29100513458252 23.619264602661133) 7.3209024 #(179.3520050048828 97.0199966430664 164.33999633789062)) ("meshes/stone2.obj" #(-186.3363800048828 -111.70317840576172 -3.1548430919647217) 8.1441136 #(99.97200012207031 48.492000579833984 135.0)) ("meshes/stone1.obj" #(95.28080749511719 -73.41743469238281 -71.31749725341797) 6.23004 #(114.15599822998047 187.9919891357422 46.72800064086914)) ("meshes/stone1.obj" #(0.46252623200416565 -82.1196060180664 -26.017505645751953) 3.022739099999999 #(54.71999740600586 21.923999786376953 222.08401489257812)) ("meshes/stone2.obj" #(-12.413314819335938 -140.1041717529297 -7.107646465301514) 5.179475099999999 #(100.44000244140625 40.17599868774414 319.0320129394531)) ("meshes/stone1.obj" #(165.06764221191406 -2.44299054145813 -90.24642944335938) 9.5887216 #(123.947998046875 267.47998046875 337.0679931640625)) ("meshes/stone2.obj" #(-127.68742370605469 -97.48826599121094 -167.7342987060547) 8.9063751 #(124.12799835205078 44.35200119018555 311.6880187988281)) ("meshes/stone1.obj" #(19.934961318969727 -103.27523040771484 66.94132232666016) 4.8361404 #(298.18798828125 170.8560028076172 290.052001953125)) ("meshes/stone2.obj" #(122.50340270996094 -135.3943634033203 -187.4691162109375) 9.0599644 #(23.075998306274414 240.98399353027344 239.79600524902344)) ("meshes/stone2.obj" #(-37.63482666015625 -153.32383728027344 -94.47660064697266) 7.511985599999999 #(314.4239807128906 202.6800079345703 250.45199584960938)) ("meshes/stone1.obj" #(3.9744231700897217 -66.32274627685547 31.319814682006836) 1.80975 #(84.45599365234375 143.3159942626953 76.5719985961914)) ("meshes/stone1.obj" #(-0.9228516221046448 -105.52030181884766 -95.50682067871094) 4.5402679 #(221.9040069580078 152.38800048828125 100.47599792480469)) ("meshes/stone2.obj" #(52.701377868652344 -56.2542839050293 -27.874082565307617) 3.0661070999999995 #(114.91200256347656 71.42400360107422 195.08399963378906)) ("meshes/stone2.obj" #(140.63897705078125 -95.30590057373047 87.01912689208984) 7.183575099999999 #(67.06800079345703 348.9840087890625 264.8160095214844)) ("meshes/stone2.obj" #(23.51321029663086 -31.465778350830078 3.6385936737060547) 1.1865455999999985 #(146.1599884033203 283.75201416015625 183.42001342773438)) ("meshes/stone3.obj" #(225.4884490966797 -105.46284484863281 -94.11742401123047) 9.059351099999999 #(24.624000549316406 11.664000511169434 42.227996826171875)) ("meshes/stone1.obj" #(-82.17887115478516 -159.18983459472656 65.68329620361328) 7.4739324 #(237.635986328125 306.4320068359375 345.0240173339844)) ("meshes/stone3.obj" #(28.551626205444336 -74.5544204711914 -43.15058898925781) 3.7226070999999994 #(98.6760025024414 138.4560089111328 304.2359924316406)) ("meshes/stone3.obj" #(98.23877716064453 -163.22068786621094 17.904775619506836) 7.257383099999998 #(196.45201110839844 127.07999420166016 141.44400024414062)) ("meshes/stone3.obj" #(-233.2893524169922 -3.1838414669036865 240.5842742919922) 9.1303399 #(254.73599243164062 250.1639862060547 121.39199829101562)) ("meshes/stone1.obj" #(-236.3223114013672 -0.32346343994140625 -108.36341094970703) 9.55056 #(128.447998046875 129.49200439453125 333.3240051269531)) ("meshes/stone2.obj" #(-259.3809509277344 -18.03973960876465 -202.66021728515625) 9.89799 #(113.29199981689453 68.43599700927734 24.875999450683594)) ("meshes/stone1.obj" #(-116.60236358642578 -1.4798647165298462 86.99337005615234) 7.309503099999999 #(22.463998794555664 233.96400451660156 263.1239929199219)) ("meshes/stone3.obj" #(252.9055633544922 -11.156828880310059 -265.13885498046875) 9.8709504 #(337.6080017089844 258.5159912109375 174.63600158691406)) ("meshes/stone2.obj" #(-38.707679748535156 -2.602768898010254 233.80772399902344) 9.45711 #(23.255998611450195 59.400001525878906 337.5)) ("meshes/stone3.obj" #(-64.63778686523438 -73.4360122680664 -105.18567657470703) 8.3222784 #(221.00399780273438 251.27999877929688 70.23600006103516)) ("meshes/stone2.obj" #(-166.3717498779297 -64.75981903076172 280.1408996582031) 9.7877151 #(118.47600555419922 197.8560028076172 52.380001068115234)) ("meshes/stone2.obj" #(-3.5629336833953857 -21.343719482421875 19.752439498901367) 0.18117190000000005 #(68.43599700927734 258.552001953125 243.07199096679688)) ("meshes/stone3.obj" #(79.14019012451172 -90.83661651611328 181.55673217773438) 7.8757119 #(59.652000427246094 295.0920104980469 150.26400756835938)) ("meshes/stone3.obj" #(-81.41280364990234 -1.2370808124542236 153.3650665283203) 8.763774399999999 #(139.9320068359375 354.7440185546875 159.8040008544922)) ("meshes/stone2.obj" #(-111.59088897705078 -59.36368179321289 11.248815536499023) 5.218277499999999 #(212.18399047851562 302.7959899902344 166.7159881591797)) ("meshes/stone1.obj" #(-309.9156799316406 -1.4351398944854736 182.22239685058594) 9.725435099999999 #(181.04400634765625 87.08399963378906 52.52399826049805)) ("meshes/stone3.obj" #(19.649486541748047 -116.15422058105469 238.42860412597656) 9.3328111 #(326.59197998046875 71.31600189208984 249.87600708007812)) ("meshes/stone1.obj" #(-12.542847633361816 -77.04533386230469 -173.34242248535156) 6.7828416 #(26.532001495361328 53.316001892089844 332.4599914550781)) ("meshes/stone2.obj" #(-12.764193534851074 -228.3696746826172 -120.20772552490234) 9.1035964 #(184.78799438476562 166.7159881591797 263.30401611328125)) ("meshes/stone2.obj" #(-275.98046875 -0.18136267364025116 -24.79738426208496) 8.93724 #(342.1080017089844 173.8800048828125 330.6600036621094)) ("meshes/stone1.obj" #(-212.24298095703125 -78.9203109741211 -149.5235137939453) 8.783385599999999 #(136.04400634765625 290.5199890136719 340.6679992675781)) ("meshes/stone1.obj" #(-3.5747687816619873 -25.395212173461914 22.964113235473633) 0.7974350999999991 #(177.6959991455078 55.65599822998047 208.15199279785156)) ("meshes/stone3.obj" #(-328.4692077636719 -64.87347412109375 -58.52947235107422) 8.9855775 #(58.5359992980957 305.38800048828125 166.53599548339844)) ("meshes/stone1.obj" #(338.7290954589844 -2.170412540435791 4.259521484375) 9.856 #(278.6759948730469 28.15199851989746 344.5559997558594)) ("meshes/stone2.obj" #(-146.9177703857422 -1.8247437477111816 213.1117401123047) 8.986851099999999 #(167.61599731445312 239.7239990234375 103.5719985961914)) ("meshes/stone1.obj" #(-146.21676635742188 -1.587520718574524 -135.13409423828125) 9.218238399999999 #(23.90399932861328 215.49598693847656 128.447998046875)) ("meshes/stone2.obj" #(227.10899353027344 -2.028132915496826 -11.538593292236328) 9.2988096 #(142.343994140625 165.63600158691406 339.1199951171875)) ("meshes/stone2.obj" #(152.6239776611328 -179.62550354003906 96.78984832763672) 9.951836400000001 #(150.22799682617188 327.2760009765625 229.53599548339844)) ("meshes/stone1.obj" #(282.3247375488281 -52.294952392578125 202.78274536132812) 9.6205296 #(106.30799865722656 109.26000213623047 194.2919921875)) ("meshes/stone3.obj" #(211.97265625 -1.1887755393981934 238.90162658691406) 8.8670044 #(184.2480010986328 165.70799255371094 294.6600036621094)) ("meshes/stone3.obj" #(159.1245574951172 -85.7672348022461 163.0296630859375) 8.5476279 #(110.9520034790039 149.3280029296875 295.8840026855469)) ("meshes/stone3.obj" #(69.36675262451172 -70.8741226196289 104.30159759521484) 8.2132471 #(186.73199462890625 265.9679870605469 331.8479919433594)) ("meshes/stone3.obj" #(79.00662994384766 -236.41226196289062 60.20176696777344) 9.9940951 #(11.988000869750977 252.0 245.66400146484375)) ("meshes/stone2.obj" #(-73.3055648803711 -35.75493240356445 -187.42733764648438) 7.9758999 #(150.19200134277344 285.8399963378906 183.74400329589844)) ("meshes/stone1.obj" #(-53.32272720336914 -139.9995880126953 -170.2987518310547) 8.1954496 #(169.1999969482422 32.43600082397461 159.51600646972656)) ("meshes/stone1.obj" #(221.03988647460938 -111.73039245605469 106.91709899902344) 8.93724 #(182.052001953125 147.20399475097656 38.15999984741211)) ("meshes/stone2.obj" #(1.0952033996582031 -0.5559009313583374 36.396854400634766) 3.375667899999999 #(114.15599822998047 50.939998626708984 295.5240173339844)) ("meshes/stone3.obj" #(-16.29415512084961 -47.73558044433594 -340.0387268066406) 9.9878199 #(0.18000000715255737 38.01599884033203 274.7879943847656)) ("meshes/stone1.obj" #(65.72030639648438 -37.602420806884766 -220.81349182128906) 8.9274375 #(7.48799991607666 208.2239990234375 324.14398193359375)) ("meshes/stone2.obj" #(-99.38870239257812 -2.235241413116455 -292.9903564453125) 9.1502775 #(236.23199462890625 171.1439971923828 134.56800842285156)) ("meshes/stone1.obj" #(347.4216003417969 -2.1950087547302246 127.5582046508789) 9.6770791 #(324.468017578125 118.44000244140625 206.89199829101562)) ("meshes/stone3.obj" #(-188.4671630859375 -90.03496551513672 74.6506576538086) 8.0001216 #(238.96800231933594 4.607999801635742 43.7760009765625)) ("meshes/stone2.obj" #(-140.83151245117188 -188.94418334960938 8.740788459777832) 9.9062976 #(303.69598388671875 344.3399963378906 258.1919860839844)) ("meshes/stone3.obj" #(-65.9385986328125 -95.08383178710938 98.6882095336914) 5.8436191 #(59.68800354003906 319.1400146484375 44.9640007019043)) ("meshes/stone1.obj" #(-222.08334350585938 -91.53854370117188 150.3601837158203) 8.190348400000001 #(235.4399871826172 57.52799606323242 151.5959930419922)) ("meshes/stone3.obj" #(-151.5538787841797 -78.39836120605469 -73.60486602783203) 8.9017404 #(339.552001953125 190.18798828125 241.12799072265625)) ("meshes/stone3.obj" #(-190.51443481445312 -2.63564133644104 -37.49065399169922) 7.318831599999999 #(358.20001220703125 105.69599914550781 69.91199493408203)) ("meshes/stone3.obj" #(37.84128952026367 -121.87716674804688 -211.99880981445312) 8.745423599999999 #(168.01199340820312 18.107999801635742 308.9159851074219)) ("meshes/stone3.obj" #(37.849517822265625 -124.61441802978516 -57.98533630371094) 6.893052399999999 #(152.27999877929688 96.01200103759766 20.95199966430664)) ("meshes/stone1.obj" #(185.4925537109375 -74.87559509277344 -175.0198974609375) 8.556000000000001 #(33.19200134277344 226.0800018310547 324.1080017089844)) ("meshes/stone2.obj" #(225.4241180419922 -0.7956058979034424 151.17971801757812) 8.8764096 #(201.70799255371094 282.05999755859375 118.9800033569336)) ("meshes/stone3.obj" #(-18.870506286621094 -67.91056060791016 180.25411987304688) 7.3198671 #(101.98800659179688 155.052001953125 210.7080078125)) ("meshes/stone3.obj" #(11.125232696533203 -26.568675994873047 6.000699996948242) 0.7571003999999992 #(33.29999923706055 3.0960001945495605 147.31201171875)) ("meshes/stone2.obj" #(-10.644466400146484 -1.6910265684127808 368.8092956542969) 9.9632764 #(306.0359802246094 324.2879943847656 52.12800216674805)) ("meshes/stone1.obj" #(151.63650512695312 -0.31062814593315125 -184.20721435546875) 7.909681600000001 #(342.4320068359375 167.94000244140625 245.98800659179688)) ("meshes/stone3.obj" #(-219.8432159423828 -0.047534309327602386 148.5013885498047) 9.49375 #(155.80799865722656 232.7760009765625 304.52398681640625)) ("meshes/stone1.obj" #(-104.85111236572266 -145.6256561279297 -59.252105712890625) 7.7228016 #(291.02398681640625 247.0679931640625 2.7360000610351562)) ("meshes/stone1.obj" #(-13.13444995880127 -243.53176879882812 147.74136352539062) 9.8756775 #(256.1399841308594 23.940000534057617 94.89599609375)) ("meshes/stone3.obj" #(-4.814833641052246 -72.83506774902344 -65.65494537353516) 4.3178556 #(58.895999908447266 56.59199905395508 351.5039978027344)) ("meshes/stone3.obj" #(-148.28701782226562 -54.1828727722168 137.4988555908203) 8.5277431 #(167.61599731445312 155.59201049804688 122.75999450683594)) ("meshes/stone3.obj" #(91.14654541015625 -99.30491638183594 40.48110580444336) 6.383180399999999 #(160.27200317382812 68.50800323486328 58.499996185302734)) ("meshes/stone3.obj" #(4.407977104187012 -56.60487365722656 -115.04486846923828) 6.0209136 #(120.88800048828125 73.656005859375 186.33599853515625)) ("meshes/stone1.obj" #(-37.1966667175293 -0.598986804485321 -17.815166473388672) 6.4167803999999995 #(354.7440185546875 69.73200225830078 154.4040069580078)) ("meshes/stone1.obj" #(7.509592056274414 -36.68598937988281 33.068946838378906) 1.8585470999999998 #(299.052001953125 166.93199157714844 105.51599884033203)) ("meshes/stone2.obj" #(5.3434929847717285 -6.009401321411133 -35.02254104614258) 2.786895099999999 #(80.27999877929688 353.9159851074219 121.68000030517578)) ("meshes/stone1.obj" #(156.34178161621094 -2.6923024654388428 -271.2911071777344) 9.5467359 #(311.3639831542969 347.6519775390625 163.25999450683594)) ("meshes/stone1.obj" #(271.5641784667969 -11.96409797668457 71.59819793701172) 9.243749999999999 #(333.9360046386719 267.0840148925781 310.67999267578125)) ("meshes/stone3.obj" #(43.892459869384766 -2.2212328910827637 -25.278461456298828) 4.289175099999999 #(4.716000080108643 42.336002349853516 316.00799560546875)) ("meshes/stone3.obj" #(-3.150322437286377 -80.62056732177734 113.947509765625) 6.54256 #(283.1399841308594 305.9280090332031 146.4119873046875)) ("meshes/stone1.obj" #(54.84245681762695 -2.7969913482666016 28.453994750976562) 6.227583599999999 #(113.68800354003906 282.49200439453125 172.2239990234375)) ("meshes/stone2.obj" #(65.19093322753906 -173.09576416015625 180.15634155273438) 8.8076791 #(46.007999420166016 280.44000244140625 204.37200927734375)) ("meshes/stone1.obj" #(-9.84632396697998 -29.778705596923828 -13.522002220153809) 0.1593600000000006 #(242.3159942626953 83.98799896240234 267.29998779296875)) ("meshes/stone3.obj" #(7.981749534606934 -51.56453323364258 61.87303924560547) 3.9362630999999992 #(0.1080000028014183 350.2080078125 252.6479949951172)) ("meshes/stone2.obj" #(61.14375686645508 -136.4775390625 -134.94007873535156) 7.034108400000001 #(309.88800048828125 97.3800048828125 137.447998046875)) ("meshes/stone1.obj" #(-68.78770446777344 -217.11224365234375 -209.17025756835938) 9.3654639 #(113.14800262451172 110.26800537109375 164.843994140625)) ("meshes/stone2.obj" #(-65.89138793945312 -83.67451477050781 22.272762298583984) 3.931589999999999 #(32.47200012207031 321.8039855957031 331.6679992675781)) ("meshes/stone3.obj" #(-113.78156280517578 -240.40577697753906 93.26087188720703) 9.5251959 #(56.23200225830078 31.608001708984375 285.3000183105469)) ("meshes/stone3.obj" #(-41.21170425415039 -51.524051666259766 -44.84403991699219) 5.0775744 #(351.9360046386719 37.11600112915039 168.08399963378906)) ("meshes/stone2.obj" #(49.06376647949219 -1.1515476703643799 197.79566955566406) 9.5195136 #(292.71600341796875 35.71200180053711 39.85199737548828)) ("meshes/stone1.obj" #(202.84153747558594 -195.40965270996094 17.822572708129883) 9.02656 #(121.96800231933594 163.00799560546875 317.1240234375)) ("meshes/stone3.obj" #(4.4375081062316895 -32.823909759521484 -46.544593811035156) 2.754585599999999 #(16.308000564575195 202.17601013183594 280.5480041503906)) ("meshes/stone1.obj" #(-4.225278377532959 -27.285419464111328 -24.46141242980957) 2.1234374999999983 #(229.2119903564453 276.0840148925781 6.948000431060791)) ("meshes/stone3.obj" #(-123.35123443603516 -117.06002044677734 104.7238998413086) 6.4929916 #(139.10400390625 154.94400024414062 241.7760009765625)) ("meshes/stone1.obj" #(41.286598205566406 -20.790302276611328 35.57854461669922) 5.6109374999999995 #(36.0 189.10800170898438 342.0)) ("meshes/stone3.obj" #(-112.92521667480469 -206.92311096191406 -121.8395004272461) 9.8645104 #(109.18799591064453 55.47600173950195 4.464000225067139)) ("meshes/stone1.obj" #(134.4152374267578 -0.8819718360900879 156.1612548828125) 8.9715151 #(120.88800048828125 153.9720001220703 308.98797607421875)) ("meshes/stone1.obj" #(-96.93181610107422 -2.9732301235198975 -66.32139587402344) 9.0121551 #(112.4280014038086 94.24799346923828 332.531982421875)) ("meshes/stone1.obj" #(36.0270881652832 -35.26410675048828 287.7403869628906) 9.8893296 #(65.23200225830078 32.90399932861328 188.4239959716797)) ("meshes/stone3.obj" #(-70.10189056396484 -132.0953826904297 1.868388295173645) 6.5835975 #(209.23199462890625 112.35599517822266 336.3119812011719)) ("meshes/stone3.obj" #(-49.437034606933594 -200.647705078125 -28.289749145507812) 8.911 #(204.08399963378906 219.16799926757812 86.6520004272461)) ("meshes/stone3.obj" #(49.07344055175781 -90.83618927001953 -13.722726821899414) 4.156926399999998 #(168.76800537109375 29.447999954223633 335.5920104980469)) ("meshes/stone1.obj" #(-13.456245422363281 -15.589831352233887 30.275371551513672) 0.3233430999999998 #(280.3680114746094 348.76800537109375 297.468017578125)) ("meshes/stone2.obj" #(-14.851054191589355 -42.24286651611328 47.87192916870117) 1.6770870999999998 #(207.28799438476562 132.5159912109375 19.54800033569336)) ("meshes/stone3.obj" #(105.82603454589844 -1.425406575202942 348.4736328125) 9.7859631 #(4.283999919891357 43.30800247192383 281.7720031738281)) ("meshes/stone1.obj" #(-47.31841278076172 -37.07858657836914 96.33843231201172) 6.320364400000001 #(203.11199951171875 37.512001037597656 107.45999908447266)) ("meshes/stone2.obj" #(223.48699951171875 -1.8408907651901245 -136.6798553466797) 9.3172231 #(230.25599670410156 56.15999984741211 232.45199584960938)) ("meshes/stone1.obj" #(291.5758056640625 -2.157029390335083 -76.45368957519531) 8.8419591 #(227.4119873046875 273.85198974609375 111.99600219726562)) ("meshes/stone1.obj" #(-177.63058471679688 -172.4766082763672 96.30567932128906) 9.098199099999999 #(356.0400085449219 275.2559814453125 3.9600000381469727)) ("meshes/stone2.obj" #(-22.87021827697754 -25.33283233642578 36.43084716796875) 1.9574975999999988 #(178.5240020751953 149.5800018310547 252.864013671875)) ("meshes/stone2.obj" #(-9.499042510986328 -49.51410675048828 28.152151107788086) 2.5090974999999993 #(220.57199096679688 214.41600036621094 245.51998901367188)) ("meshes/stone3.obj" #(54.48278045654297 -0.5674801468849182 106.95811462402344) 9.438783899999999 #(174.77999877929688 301.71600341796875 122.83200073242188)) ("meshes/stone3.obj" #(-97.49322509765625 -0.6960082054138184 309.8382873535156) 9.7436799 #(338.7959899902344 199.3319854736328 279.7200012207031)) ("meshes/stone1.obj" #(-7.7501606941223145 -151.89498901367188 138.17832946777344) 8.5468656 #(86.2560043334961 6.192000389099121 231.87600708007812)) ("meshes/stone1.obj" #(-22.425342559814453 -130.50640869140625 49.20117950439453) 5.82684 #(62.279998779296875 244.25999450683594 292.0679931640625)) ("meshes/stone3.obj" #(14.888784408569336 -24.001985549926758 -33.8335075378418) 0.8242758999999988 #(164.95199584960938 340.55999755859375 259.7040100097656)) ("meshes/stone3.obj" #(-93.69579315185547 -2.0965235233306885 -388.4240417480469) 9.9444975 #(331.12799072265625 100.33200073242188 103.03199768066406)) ("meshes/stone3.obj" #(-12.155936241149902 -31.84453582763672 29.140174865722656) 0.9045630999999998 #(18.827999114990234 284.94000244140625 222.1199951171875)) ("meshes/stone1.obj" #(-148.5323944091797 -118.65320587158203 190.51596069335938) 8.1484191 #(351.14398193359375 266.3280029296875 320.90399169921875)) ("meshes/stone1.obj" #(67.50272369384766 -0.47643744945526123 -304.82025146484375) 9.4278336 #(196.59600830078125 351.9360046386719 206.3159942626953)) ("meshes/stone3.obj" #(139.96754455566406 -92.68148803710938 257.1688232421875) 9.4851639 #(27.035999298095703 145.25999450683594 179.7480010986328)) ("meshes/stone2.obj" #(-18.85696792602539 -1.438407301902771 147.7811737060547) 7.372412399999999 #(128.447998046875 172.83599853515625 225.10800170898438)) ("meshes/stone3.obj" #(11.585140228271484 -2.2937238216400146 0.9181565046310425) 4.040159999999999 #(152.2080078125 166.86000061035156 227.95199584960938)) ("meshes/stone3.obj" #(-22.56243324279785 -109.1247329711914 -45.66133117675781) 4.635902399999999 #(202.2119903564453 118.33200073242188 68.2560043334961)) ("meshes/stone1.obj" #(-64.50324249267578 -0.8897191882133484 -130.72369384765625) 5.4369975 #(36.57600021362305 252.0 339.1920166015625)) ("meshes/stone1.obj" #(-9.2561616897583 -56.2843017578125 -17.373579025268555) 2.7256159 #(358.12799072265625 233.78399658203125 341.2799987792969)) ("meshes/stone2.obj" #(10.089054107666016 -24.128873825073242 -17.625282287597656) 0.3489023999999985 #(135.79200744628906 175.42800903320312 54.8640022277832)) ("meshes/stone1.obj" #(-56.95187759399414 -44.64596939086914 3.0728821754455566) 3.2891136 #(224.67601013183594 155.95199584960938 216.17999267578125)) ("meshes/stone3.obj" #(39.307369232177734 -74.90048217773438 29.605138778686523) 5.2858044 #(147.09600830078125 242.10000610351562 265.427978515625)) ("meshes/stone3.obj" #(-5.388667583465576 -26.700397491455078 38.339908599853516) 1.5599030999999985 #(62.20800018310547 236.16000366210938 88.20000457763672)) ("meshes/stone1.obj" #(-28.90506935119629 -75.72052001953125 48.5035514831543) 5.172529599999999 #(251.67601013183594 97.88400268554688 323.85601806640625)) ("meshes/stone2.obj" #(117.46116638183594 -181.9735565185547 -100.28015899658203) 8.9995431 #(329.50799560546875 330.0480041503906 339.5880126953125)) ("meshes/stone2.obj" #(-94.28297424316406 -276.0341491699219 5.265388488769531) 9.8409879 #(259.16400146484375 304.343994140625 40.104000091552734)) ("meshes/stone3.obj" #(-220.2914581298828 -1.8381301164627075 -308.7131652832031) 9.9621775 #(335.4119873046875 163.3679962158203 10.116000175476074)) ("meshes/stone3.obj" #(144.67388916015625 -80.01587677001953 17.27077865600586) 5.9103975 #(272.8079833984375 281.0879821777344 270.21600341796875)) ("meshes/stone2.obj" #(0.1784145087003708 -25.48023796081543 28.526031494140625) 0.5171356000000005 #(331.81201171875 166.78799438476562 9.64799976348877)) ("meshes/stone3.obj" #(-277.7756042480469 -53.69589614868164 55.61980056762695) 9.4810716 #(29.95199966430664 225.0 121.4280014038086)) ("meshes/stone2.obj" #(-325.5940856933594 -2.3850083351135254 -129.4479522705078) 8.8014556 #(329.03997802734375 107.31599426269531 71.53199768066406)) ("meshes/stone3.obj" #(40.87827682495117 -203.76185607910156 -51.300865173339844) 8.9976444 #(188.71200561523438 323.5679931640625 280.0799865722656)) ("meshes/stone1.obj" #(8.358683586120605 -18.337018966674805 61.70615005493164) 2.700006399999999 #(80.38800048828125 285.4440002441406 108.36000061035156)) ("meshes/stone2.obj" #(-77.78781127929688 -91.9129867553711 232.47061157226562) 9.1279791 #(95.0040054321289 181.69200134277344 68.83200073242188)) ("meshes/stone1.obj" #(32.89928436279297 -36.217891693115234 -5.113857269287109) 1.462239999999999 #(58.96800231933594 115.8479995727539 293.18402099609375)) ("meshes/stone3.obj" #(157.42340087890625 -138.93191528320312 -28.665386199951172) 8.1869436 #(102.52799987792969 327.31201171875 353.1600036621094)) ("meshes/stone3.obj" #(-208.14051818847656 -153.0019073486328 -93.4469223022461) 9.8139504 #(73.83599853515625 77.47200012207031 348.0119934082031)) ("meshes/stone3.obj" #(-80.65493774414062 -52.8579216003418 52.04835510253906) 5.1041991 #(323.1719970703125 74.26800537109375 86.6520004272461)) ("meshes/stone1.obj" #(-229.98878479003906 -219.76329040527344 -23.985309600830078) 9.9204336 #(132.47999572753906 249.7320098876953 334.5480041503906)) ("meshes/stone2.obj" #(49.75764846801758 -86.75350952148438 -102.66310119628906) 5.0339791 #(126.7560043334961 231.83999633789062 322.81201171875)) ("meshes/stone3.obj" #(111.3868408203125 -32.058860778808594 50.336021423339844) 7.4919936 #(203.04000854492188 182.2679901123047 349.99200439453125)) ("meshes/stone2.obj" #(23.690326690673828 -56.360435485839844 -4.157132148742676) 1.8837918999999992 #(56.448001861572266 115.19999694824219 266.6880187988281)) ("meshes/stone2.obj" #(-13.670774459838867 -0.9794718623161316 -253.2682647705078) 9.7130364 #(102.05999755859375 281.30401611328125 288.8639831542969)) ("meshes/stone1.obj" #(-2.495091438293457 -1.361960768699646 -162.9365692138672) 8.5015359 #(9.720000267028809 178.27200317382812 117.89999389648438)) ("meshes/stone3.obj" #(165.38050842285156 -57.08414840698242 -49.196083068847656) 8.7644775 #(110.59200286865234 281.23199462890625 62.711997985839844)) ("meshes/stone2.obj" #(-8.17831039428711 -39.63124465942383 -33.052154541015625) 0.9787995999999988 #(316.9079895019531 85.28400421142578 341.8559875488281)) ("meshes/stone2.obj" #(-350.832763671875 -0.5678118467330933 92.30047607421875) 9.9998911 #(205.1999969482422 11.520000457763672 198.54000854492188)) ("meshes/stone2.obj" #(-76.68949127197266 -75.29401397705078 -20.438091278076172) 4.7306919 #(355.2120056152344 226.04400634765625 310.9319763183594)) ("meshes/stone3.obj" #(-269.9877014160156 -121.208251953125 -4.57593297958374) 8.660440000000001 #(330.4079895019531 257.2560119628906 164.37600708007812)) ("meshes/stone3.obj" #(56.655433654785156 -206.62339782714844 -179.42575073242188) 9.584247900000001 #(305.8919982910156 286.0199890136719 295.8840026855469)) ("meshes/stone2.obj" #(58.00538635253906 -2.091200113296509 -82.22380828857422) 7.4203759 #(293.0760192871094 324.57598876953125 183.77999877929688)) ("meshes/stone2.obj" #(258.2915954589844 -123.93866729736328 -12.322759628295898) 8.9424496 #(23.7239990234375 196.81199645996094 348.2640075683594)) ("meshes/stone2.obj" #(-35.224342346191406 -74.7881851196289 -3.203505039215088) 4.219439099999999 #(350.0279846191406 335.23199462890625 46.332000732421875)) ("meshes/stone2.obj" #(142.08035278320312 -103.41251373291016 -112.92452239990234) 7.6263616 #(258.73199462890625 106.77600860595703 112.1760025024414)) ("meshes/stone1.obj" #(-119.55654907226562 -107.41544342041016 37.519737243652344) 5.8539279 #(93.5999984741211 1.1519999504089355 146.98800659179688)) ("meshes/stone2.obj" #(-197.02182006835938 -1.325155258178711 54.832088470458984) 9.7652976 #(358.91998291015625 204.947998046875 58.1400032043457)) ("meshes/stone3.obj" #(300.12054443359375 -2.117861032485962 -185.0662078857422) 8.817327899999999 #(291.6360168457031 178.99200439453125 257.50799560546875)) ("meshes/stone3.obj" #(-15.930624008178711 -32.432151794433594 15.286455154418945) 1.9179899999999994 #(268.95599365234375 152.96400451660156 232.95599365234375)) ("meshes/stone1.obj" #(63.165924072265625 -151.20712280273438 94.14155578613281) 8.0224191 #(289.97998046875 59.97600173950195 348.6600036621094)) ("meshes/stone2.obj" #(123.14495086669922 -0.6858820915222168 255.06692504882812) 9.190597499999999 #(163.00799560546875 279.6839904785156 35.56800079345703)) ("meshes/stone3.obj" #(7.57897424697876 -42.39999008178711 10.271751403808594) 2.5073663999999996 #(313.3800048828125 337.6800231933594 357.1199951171875)) ("meshes/stone3.obj" #(0.5855578184127808 -96.3184585571289 8.708444595336914) 4.4676156 #(283.1759948730469 335.9519958496094 236.33999633789062)) ("meshes/stone2.obj" #(-12.553692817687988 -205.547607421875 55.12846755981445) 9.3374524 #(76.60800170898438 146.55599975585938 212.11199951171875)) ("meshes/stone2.obj" #(210.44775390625 -73.95209503173828 33.71677017211914) 7.6632444 #(60.407997131347656 336.2040100097656 263.26800537109375)) ("meshes/stone1.obj" #(122.35541534423828 -225.6978759765625 -24.264909744262695) 8.5537191 #(106.2719955444336 267.6239929199219 2.447999954223633))))

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

(define ornament-view%
  (class object%
    (init-field
     (pos (vector 0 0 0))
     (property 'none)
     (time 0))
    
    (field
     (rot (vmul (rndvec) 360))
     (root (with-state
            (translate pos)
            (rotate rot)
            (scale 0.01)            
            (cond 
              ((eq? property 'wiggle) 
;               (opacity 1)
               (hint-depth-sort)
               (colour (vector 0.5 0.0 0.0))
               (load-primitive "meshes/wiggle.obj"))
              ((eq? property 'leaf) 
               (colour (vector 0.8 1 0.6))
               (texture (load-texture "textures/leaf2.png"))
               (load-primitive "meshes/leaf.obj"))
              (else (error ""))))))
    
    (define/public (update t d)
      (when (< time 1)
        (with-primitive root
                        (identity)
                        (translate pos)
                        (rotate rot)
                        (scale (* 0.2 time)))
        (set! time (+ time (* 0.1 d)))))
    
    (super-new)))

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

(define pickup-view%
  (class object%
    (init-field
     (id -1)
     (type 'none)
     (pos (vector 0 0 0)))
    
    (field
     (rot (vmul (rndvec) 360))
     (root (with-state
            (translate pos)
            (rotate rot)
            (colour (pickup-colour))
            (scale 0.3)
            (texture
             (cond 
              ((eq? type 'wiggle) (load-texture "textures/wiggle.png"))
              ((eq? type 'leaf) (load-texture "textures/leaf.png"))
              ((eq? type 'curly) (load-texture "textures/curl.png"))))
            (load-primitive "meshes/pickup.obj")))
     (from pos)
     (destination (vector 0 0 0))
     (speed 0.05)
     (t -1))
    
    (define/public (pick-up)
      (destroy root))
    
    (define/public (move-to s)
      (set! t 0)
      (set! from pos)
      (set! destination s))
    
    (define/public (update t d)
      (with-primitive root
                      (rotate (vector (* d 10) 0 0)))
      #;(when (and (>= t 0) (< t 1))
        (set! pos (vadd pos (vmul (vsub destination from) speed)))
        (with-primitive root
                        (identity)
                        (translate pos)
                        (rotate rot))
        (set! t (+ t speed))))
    
    (super-new)))

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

(define twig-view%
    (class object%
      (init-field
       (id 0)
       (pos (vector 0 0 0))
       (type 'none)
       (dir (vector 0 1 0))
       (radius 1)
       (num-points 0)) 
      
      (field
       (index 0)
       (parent-twig-id -1)
       (child-twig-ids '())
       (ornaments '())
       (col (vector 1 1 1))
       (tex "")
	   (markers '())
	   (grow-t 999)
	   (marker-destroy-t 0)
	   (grow-speed default-grow-speed))
      
      (define/public (get-id)
        id)
      
      (define/public (get-dir)
        dir)
      
      (define/public (set-col! s)
        (set! col s))

      (define/public (set-tex! s)
        (set! tex s))

      (define/public (build)
        0)
      
      (define/public (get-num-points)
        index)

      (define/public (set-pos! s)
        (set! pos s))
      
      (define/public (get-child-twig-ids)
        child-twig-ids)
      
      (define/public (get-root)
        (error "need to overide this"))
      
      (define/public (destroy-twig)
        (destroy (get-root)))

      (define/public (set-parent-twig-id s)
        (set! parent-twig-id s))
      
      (define/public (get-point point-index)
        (error "need to overide this"))
      
      (define/public (get-width point-index)
        (error "need to overide this"))
      
      (define/public (add-child-twig-id twig-id)
        (set! child-twig-ids (cons twig-id child-twig-ids)))
      
      (define/public (start-growing)
	  	(set! grow-t 0)
		(set! markers (cons (build-locator) markers)))
		
      (define/pubment (add-point point width)
    (when audio-on (let ((growing-noise (oa-load-sample (fullpath "snd/event01.wav")))) 
      (oa-play growing-noise (vector 0 0 0) (rndf) 0.3)))
	  
	  	  	(set! markers (append markers (list (with-state
				(parent (get-root))
				(translate point)
				(scale 0.2)
				(shader "shaders/toon.vert.glsl" "shaders/toon.frag.glsl")
				(colour col)
				(build-sphere 10 10)))))
	  
        (inner (void) add-point point width))

      (define/public (add-ornament point-index property)
        (when (< (length ornaments) max-ornaments)
          (with-state
           (parent (get-root))
           ; todo - different ornament-view objects per property needed?
           ; todo - delete existing ornaments here
           (set! ornaments (cons (list point-index 
                                       (make-object ornament-view% 
                                         (get-point point-index)
                                         property))
                                 ornaments)))))
      
      (define/pubment (update t d)        
        (for-each
         (lambda (ornament)
           (send (cadr ornament) update t d))
         ornaments)
                
        (inner (void) update t d)
		
		(when (< grow-t num-points) 
			(set! grow-t (+ grow-t (* d grow-speed)))
			(when (> 0 (- marker-destroy-t grow-t))
				; soundtodo: marker gobble
				(set! marker-destroy-t (+ 1 marker-destroy-t))
				(destroy (car markers))
				(set! markers (cdr markers)))))
      
      (super-new)))

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

(define ribbon-twig-view%
    (class twig-view%
      
      (inherit-field pos radius num-points index col tex)
      
      (field
       (root 0))
      
      (define/override (build)
        (set! root (let ((p (with-state
                       (translate pos)
                       (colour col)
                       (texture (load-texture tex)) 
                       (build-ribbon num-points))))
               (with-primitive p
                               (pdata-map! 
                                (lambda (w)
                                  0)
                                "w")
                               (pdata-set! "w" 0 radius))
               p)))
      
      
      (define/override (get-root)
        root)

      (define/override (get-point point-index)
        (with-primitive root
                        (pdata-ref "p" point-index)))
      
      (define/override (get-width point-index)
        (with-primitive root
                        (pdata-ref "w" point-index)))
           
      (define/augment (add-point point width)
        (with-primitive root
                        (pdata-index-map! ; set all the remaining points to the end
                         (lambda (i p)    ; in order to hide them
                           (if (< i index)
                               p
                               point))
                         "p")
                        (pdata-index-map! ; do a similar thing with the width
                         (lambda (i w)    
                           (if (< i (+ index 1))
                               w
                               width))
                         "w"))
        (set! index (+ index 1)))

      (define/augment (update t d)
        0)

      (super-new)))

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

(define extruded-twig-view%
    (class twig-view%
      
      (inherit-field index radius num-points pos dir col tex grow-t)
      
      (field
       (profile '())
       (path '())
       (root 0)
       (widths '()))
      
      (define/override (build)
       (set! profile (build-circle-profile 12 1))
       (set! path (build-list num-points (lambda (_) (vector 0 0 0))))
       (set! widths (build-list num-points (lambda (_) 1)))
       (set! root (let ((p (with-state
                            (backfacecull 0)
                            (when wire-mode 
                              (hint-none)
                              (hint-wire))
						(shader "shaders/toon.vert.glsl" "shaders/toon.frag.glsl")
                       (texture (load-texture tex))
                       (opacity 0.6)
                       (colour col)
                       #;(colour (vector 1 1 1))
                       #;(texture (load-texture "textures/root.png")) 
                       (build-partial-extrusion profile path 3))))
               p)))
      
      (define/override (get-root)
        root)
      
      (define/override (get-point point-index)
        (list-ref path point-index))

      (define/override (get-width point-index)
        (list-ref widths point-index))

      (define (list-set l c s)
        (cond ((null? l) '())
              ((zero? c) (cons s (list-set (cdr l) (- c 1) s)))
              (else (cons (car l) (list-set (cdr l) (- c 1) s)))))
            
      (define/augment (add-point point width)
        (set! path (list-set path index point))
        (set! widths (list-set widths index width))
        (set! index (+ index 1)))

      (define/augment (update t d)                   
        (when (< grow-t (length path))
          (with-primitive root
            (partial-extrude grow-t profile path widths (vector 1 0 0) 0.05))))
      
      (define/public (get-end-pos)
	  	(list-ref path (if (zero? index) 0 (- index 1)))
        #;(with-primitive root (pdata-ref "p" (- (* index (length profile)) 1))))

      (super-new)))

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

(define plant-view%
    (class object%
      
      (init-field
       (id "none")
       (pos (vector 0 0 0))
       (size 0)
       (col (vector 1 1 1))
       (tex "ooo"))
       
       (field 
        (twigs '()) ; a assoc list map between ids and twigs stored flat here,       
                    ; for fast access, but prims heirachically in the scenegraph
        (root (with-state 
               (translate pos)
               (build-locator)))
        (seed (with-state
               (parent root)
			   (shader "shaders/toon.vert.glsl" "shaders/toon.frag.glsl")
               (texture (load-texture tex))
               (backfacecull 0)
               (opacity 0.6)
               (colour col)
               (hint-depth-sort)
               (scale (* 0.12 size))
                            (when wire-mode 
                              (hint-none)
                              (hint-wire))
               ;(hint-unlit)
               (load-primitive "meshes/seed.obj")))
        (nutrients (let ((p (with-state
                            (hint-depth-sort)
                            (hint-unlit)
                            (parent root)
                            (blend-mode 'src-alpha 'one)
                            (texture (load-texture "textures/star.png"))
                            (build-particles 100))))
                        (with-primitive p
                                      (pdata-add "twig" "f")
                                      (pdata-add "point" "f")
                                      (pdata-add "offset" "v")
                                      (pdata-add "speed" "f")
                                      (pdata-map! 
                                       (lambda (point)
                                         0)
                                       "point")
                                      (pdata-map! 
                                       (lambda (point)
                                         (* 0.12 (+ 0.1 (rndf))))
                                       "speed")
                                      (pdata-map! 
                                       (lambda (offset)
                                         (vector 0 0 0))
                                       "offset")
                                      (pdata-map! 
                                       (lambda (c)
                                         (vector 0 (rndf) (rndf)))
                                       "c")
                                      (pdata-map! 
                                       (lambda (p)
                                         (vmul (vadd (crndvec) (vector 0 -1 0)) 900))
                                       "p")
                                      (pdata-map! 
                                (lambda (s)
                                    (vmul (vector 1 1 1) (+ 0.1 (rndf))))
                                "s"))
                        p)))
        
      (define/public (get-id)
        id)
      
      (define/public (get-col)
        col)
      
      (define/public (get-twig twig-id)
        (let ((l (assq twig-id twigs)))
          (if l              
              (cadr (assq twig-id twigs))
              #f)))
      
      (define/public (destroy-branch-twig twig-id)
        (for-each
         (lambda (twig-id)
           (destroy-branch-twig twig-id))
         (send (get-twig twig-id) get-child-twig-ids))
        (send (get-twig twig-id) destroy-twig)
        (set! twigs (assoc-remove twig-id twigs)))
      
      (define/public (destroy-plant)
        (destroy root)
        (for-each
         (lambda (twig)
           (destroy-branch-twig (car twig)))
         twigs))
      
      (define/public (add-twig parent-twig-id point-index twig)
        (let ((ptwig (get-twig parent-twig-id)))
          (when ptwig                        
            (send twig set-pos! (send ptwig get-point point-index)) ; attach to parent twig   
            ; tell the twigs about this relationship (might turn out to be overkill)
            (send ptwig add-child-twig-id (send twig get-id))
            (send twig set-parent-twig-id parent-twig-id))
            
          (send twig set-col! col)   
          (send twig set-tex! tex)   
          (send twig build)
          
          (with-primitive (send twig get-root)
                          (parent root))
                    
          (set! twigs (cons (list (send twig get-id) twig) twigs))))
      
      (define/public (add-twig-point twig-id point width)
        (send (get-twig twig-id) add-point point width))

      (define/public (start-twig-growing twig-id)
        (send (get-twig twig-id) start-growing))
      
      (define/public (grow-seed amount)
        (with-primitive seed (scale amount)))
      
      (define/public (add-ornament twig-id point-index property)
        (send (get-twig twig-id) add-ornament point-index property))
      
      (define/public (update-nutrients t d)
       (when (not (null? twigs))
          (with-primitive nutrients
                          (pdata-index-map!
                           (lambda (i p twig-id point offset speed)
                             (let* ((twig-id (inexact->exact twig-id))
                                    (twig (get-twig twig-id))
                                    (point (inexact->exact point)))
                             (cond 
                               ((or (< point 1) (not twig))
                                (let* ((new-twig (choose twigs))
                                       (num-points (send (cadr new-twig) get-num-points))
                                       (new-point (if (zero? num-points) 0 (random num-points))))
                                  (pdata-set! "twig" i (car new-twig))
                                  (pdata-set! "point" i new-point)
                                  (pdata-set! "offset" i (vmix offset (vmul (srndvec) (send (cadr new-twig) get-width new-point)) 0.2))
                                  (send (cadr new-twig) get-point new-point)))
                               ((< (vdist (vadd (send twig get-point point) offset) p) 0.1)
                                (pdata-set! "point" i (- point 1))                               
                                (vadd p (vmul (vnormalise (vsub (vadd (send twig get-point (- point 1)) offset) p)) speed)))
                               (else
                                (vadd p (vmul (vnormalise (vsub (vadd (send twig get-point point) offset) p)) speed))))))
                           "p" "twig" "point" "offset" "speed"))))
              
      (define/public (update t d)
        (update-nutrients t d)
        (with-primitive seed
                        (scale (+ 1 (* 0.001 (sin (* 2 t))))))                       
        
        (for-each 
         (lambda (twig)
           (send (cadr twig) update t d))
         twigs))
        
      (super-new)))

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

(define (build-env-box top bottom left right front back lower)    
  (let ((p (build-locator)))
    (with-state
     (parent p)
  (hint-unlit)  
  
  (let ((t (with-state
        (texture (load-texture top))
        (translate (vector 0 0.5 0))
        (rotate (vector 90 0 0))
        (build-plane))))
      (when lower (with-primitive t
                      (pdata-map!
                       (lambda (t)
                         (vmul t 10))
                       "t"))))
    
    (with-state
        (texture (load-texture left))
        (translate (vector 0 0 -0.5))
        (rotate (vector 0 0 0))
        (build-plane))
    
    (with-state
        (texture (load-texture back))
        (translate (vector 0.5 0 0))
        (rotate (vector 0 90 0))
        (build-plane))
    
    (with-state
        (texture (load-texture right))
        (translate (vector 0 0 0.5))
        (rotate (vector 0 0 0))
        (build-plane))
    
    (with-state
        (texture (load-texture front))
        (translate (vector -0.5 0 0))
        (rotate (vector 0 90 0))
        (build-plane))
    
    (when lower
      (with-state
        (texture (load-texture bottom))
        (translate (vector 0 -0.5 0))
        (rotate (vector 90 0 0))        
        (build-plane)))
                         
    p)))

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

(define game-view%
  (class object%
    
    (field
     (plants '()) ; map of ids -> plants     
     (pickups '()) ; map of ids -> pickups
     (camera-dist 1)
     (env-root (with-state (scale 1000) (build-locator)))
     (root-camera-t 0)
     #;(upper-env (with-state
                 (parent env-root)
                 (hint-depth-sort)
                 (colour 2)
                 (translate (vector 0 0.28 0))
                 (build-env-box "textures/top.png" "textures/bottom-trans.png" 
                                "textures/left.png" "textures/right.png"
                                "textures/front.png" "textures/back.png")))
    #;(lower-env (with-state
                (parent env-root)
                 (hint-depth-sort)
                 (translate (vector 0 -0.22001 0))
                 (build-env-box "textures/bottom-trans.png" "textures/bottom.png" 
                                "textures/sleft.png" "textures/sright.png"
                                "textures/sfront.png" "textures/sback.png")))
    (upper-env (with-state
                 (parent env-root)
                 ;(hint-depth-sort)
                 (hint-unlit)
                 (translate (vector 0 0.28 0))
                 (build-env-box "textures/sky-top.png" "textures/floor.png" 
                                "textures/sky-side.png" "textures/sky-side.png"
                                "textures/sky-side.png" "textures/sky-side.png" #f)))
    (lower-env (with-state
                (parent env-root)
                 ;(hint-depth-sort)
                 (hint-unlit)
                 (colour (earth-colour))
                 (translate (vector 0 -0.22001 0))
                 (build-env-box "textures/floor.png" "textures/earth-bottom.png" 
                                "textures/earth-side.png" "textures/earth-side.png"
                                "textures/earth-side.png" "textures/earth-side.png" #t)))
								
	(stones '()))
    
    (define/public (setup)      
      (let ((l (make-light 'point 'free)))
      (light-diffuse 0 (vector 0.5 0.5 0.5))
      (light-diffuse l (vector 1 1 1))
      (light-position l (vector 10 50 -4)))

      (clear-colour fog-col)
      (clip 0.5 10000)
      (fog fog-col fog-strength 1 100)
	  
	  (set! stones
           (map 
              (lambda (stone)
                (let ((p (with-state  
                          (hint-frustum-cull)
				(shader "shaders/toon.vert.glsl" "shaders/toon.frag.glsl")
		         (colour (stones-colour))
                 (translate (list-ref stone 1))
                 (scale (list-ref stone 2))
                 (rotate (list-ref stone 3))
                 (texture (load-texture "textures/quartz.png"))
                 (load-primitive (list-ref stone 0)))))
                  (with-primitive p (apply-transform) (recalc-bb)) ; apply the transform to speed up the ray tracing, don't have to tranform the ray into object space
                  p))
              stones-list)))

    (define/public (get-stones)
      stones)
	
    (define/public (add-plant plant)
      (destroy-plant (send plant get-id)) ; just in case
      (set! plants (cons (list (send plant get-id) plant) plants)))
    
    (define/public (get-plant plant-id)
      (let ((p (assoc plant-id plants)))
        (if (not p) #f (cadr p))))
    
    (define/public (destroy-plant plant-id)
      (let ((p (get-plant plant-id)))
        (when p (send p destroy-plant)
          (set! plants (assoc-remove plant-id plants)))))
    
    (define/public (destroy-branch-twig plant-id twig-id)
      (send (get-plant plant-id) destroy-branch-twig twig-id))
    
    (define/public (add-twig plant-id parent-twig-id point-index twig)
      (send (get-plant plant-id) add-twig parent-twig-id point-index twig))
    
    (define/public (grow-seed plant-id amount)    
      (send (get-plant plant-id) grow-seed amount))
    
    (define/public (get-pickup pickup-id)
      (cadr (assq pickup-id pickups)))
    
    (define/public (add-pickup pickup-id type pos)
      (set! pickups (cons (list pickup-id (make-object pickup-view% pickup-id type pos)) pickups)))
    
    (define/public (pick-up-pickup pickup-id)
      (send (get-pickup pickup-id) pick-up)
      (set! pickups (assoc-remove pickup-id pickups)))
    
    (define/public (add-ornament plant-id twig-id point-index property)
      (send (get-plant plant-id) add-ornament twig-id point-index property))
                                 
    (define/public (update t d messages)      
                        
      (for-each 
       (lambda (plant)
         (send (cadr plant) update t d))
       plants)

      (for-each 
       (lambda (pickup)
         (send (cadr pickup) update t d))
       pickups)
      
      (when debug-messages
        (for-each
         (lambda (msg)
           (send msg print))
         messages))      
      (for-each
       (lambda (msg)
         (cond
           ((eq? (send msg get-name) 'player-plant) ; not really any difference now
            (add-plant (make-object plant-view% 
                         (send msg get-data 'plant-id) 
                         (send msg get-data 'pos)
                         (send msg get-data 'size)
                         (send msg get-data 'col)
                         (send msg get-data 'tex))))
                      
           ((eq? (send msg get-name) 'new-plant)
            (printf "adding new plant to view ~a~n" (send msg get-data 'plant-id))
            (add-plant (make-object plant-view% 
                         (send msg get-data 'plant-id) 
                         (send msg get-data 'pos)
                         (send msg get-data 'size)
                         (send msg get-data 'col)
                         (send msg get-data 'tex))))
           
           ((eq? (send msg get-name) 'grow-seed)
            (grow-seed (send msg get-data 'plant-id) 
                       (send msg get-data 'amount)))
           
           ((eq? (send msg get-name) 'destroy-branch-twig)
            (destroy-branch-twig (send msg get-data 'plant-id) (send msg get-data 'twig-id)))          
           
           ((eq? (send msg get-name) 'new-twig)
            (add-twig (send msg get-data 'plant-id)
                      (send msg get-data 'parent-twig-id)
                      (send msg get-data 'point-index)
                      (cond                         
                        ((eq? (send msg get-data 'render-type) 'ribbon)
                         (make-object ribbon-twig-view%                               
                           (send msg get-data 'twig-id)
                           (vector 0 0 0) ; will be filled in by add-twig
                           (send msg get-data 'type)                               
                           (send msg get-data 'dir)
                           (send msg get-data 'width)
                           (send msg get-data 'num-points)))
                        
                        ((eq? (send msg get-data 'render-type) 'extruded)
                         (make-object extruded-twig-view%                               
                           (send msg get-data 'twig-id)
                           (vector 0 0 0) ; will be filled in by add-twig
                           (send msg get-data 'type)                               
                           (send msg get-data 'dir)
                           (send msg get-data 'width)
                           (send msg get-data 'num-points))))))
           
           ((eq? (send msg get-name) 'add-twig-point)
            (send (get-plant (send msg get-data 'plant-id)) add-twig-point
                  (send msg get-data 'twig-id)
                  (send msg get-data 'point)
                  (send msg get-data 'width)))
           
           ((eq? (send msg get-name) 'start-growing)
            (send (get-plant (send msg get-data 'plant-id)) start-twig-growing
                  (send msg get-data 'twig-id)))                  
           
           ((eq? (send msg get-name) 'new-pickup)
            (add-pickup 
             (send msg get-data 'pickup-id) 
             (send msg get-data 'type) 
             (send msg get-data 'pos)))
           
           ((eq? (send msg get-name) 'pick-up-pickup)
            (pick-up-pickup 
             (send msg get-data 'pickup-id)))

           ((eq? (send msg get-name) 'new-ornament)
            (add-ornament 
             (send msg get-data 'plant-id)
             (send msg get-data 'twig-id)
             (send msg get-data 'point-index)
             (send msg get-data 'property)))            
                      
           ))
       messages))
    
    


    (super-new)))
